/*
    SA-MP Traffic Sign objects
    Copyright (C) 2011  Vince0789

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

// -----------------------------------------------------------------------------

#include <a_samp>
#tryinclude <zcmd>

// -----------------------------------------------------------------------------

new
	sign[2];

// -----------------------------------------------------------------------------

public OnFilterScriptInit()
{
	sign[0] = CreateObject(19412, 2353.760, -1653.16, 12.49, 0.0, 0.0, 0.0); // Pole object
	sign[1] = CreateObject(19413, 2353.806, -1653.16, 14.54, 0.0, 0.0, 90.0); // The Sign
	return 1;
}

public OnFilterScriptExit()
{
	DestroyObject(sign[0]);
	DestroyObject(sign[1]);
}

// -----------------------------------------------------------------------------

#if defined _zcmd_included

CMD:changesign(playerid, params[])
{
	if(isnull(params))
	    return SendClientMessage(playerid, -1, "/changesign [19413 - 19428]");

	new val = strval(params);
	if(!(19413 <= val <= 19428))
		return SendClientMessage(playerid, -1, "/changesign [19413 - 19428]");
		
	DestroyObject(sign[1]);
	sign[1] = CreateObject(val, 2353.806, -1653.16, 14.54, 0.0, 0.0, 90.0);
	return 1;
}

#else // No ZCMD :<

public OnPlayerCommandText(playerid, cmdtext[])
{
	if(!strcmp(cmdtext, "/changesign", true, 11))
	{
		if(!strlen(cmdtext[12]))
			return SendClientMessage(playerid, -1, "/changesign [19413 - 19428]");

		new val = strval(cmdtext[12]);
		if(!(19413 <= val <= 19428))
			return SendClientMessage(playerid, -1, "/changesign [19413 - 19428]");

		DestroyObject(sign[1]);
		sign[1] = CreateObject(val, 2353.806, -1653.16, 14.54, 0.0, 0.0, 90.0);
		return 1;
	}
	return 0;
}

#endif

// -----------------------------------------------------------------------------
// EOF

